package nemosofts.voxradio.asyncTask;

import android.os.AsyncTask;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.interfaces.HomeListener;
import nemosofts.voxradio.item.ItemCat;
import nemosofts.voxradio.item.ItemCountries;
import nemosofts.voxradio.item.ItemHomeSlider;
import nemosofts.voxradio.item.ItemPodcasts;
import nemosofts.voxradio.item.ItemPost;
import nemosofts.voxradio.item.ItemRadio;
import nemosofts.voxradio.utils.ApplicationUtil;
import okhttp3.RequestBody;

public class LoadHome extends AsyncTask<String, String, String> {

    RequestBody requestBody;
    HomeListener homeListener;
    ArrayList<ItemPost> arrayListPost = new ArrayList<>();
    String message = "", successAPI = "1";

    public LoadHome(HomeListener homeListener, RequestBody requestBody) {
        this.homeListener = homeListener;
        this.requestBody = requestBody;
    }

    @Override
    protected void onPreExecute() {
        homeListener.onStart();
        super.onPreExecute();
    }

    @Override
    protected String doInBackground(String... strings) {
        try {
            String json = ApplicationUtil.responsePost(Callback.API_URL, requestBody);
            JSONObject mainJson = new JSONObject(json);

            try {

                JSONObject jsonObject = mainJson.getJSONObject(Callback.TAG_ROOT);

                ItemPost itemPost;
                String postTitle, postType, postId;

                if (jsonObject.has("slider")) {

                    JSONArray jsonArrayBanner = jsonObject.getJSONArray("slider");

                    postTitle = "Home Banners";
                    postType = "slider";
                    itemPost = new ItemPost("", postTitle, postType, false);

                    ArrayList<ItemHomeSlider> arrayListBanner = new ArrayList<>();
                    for (int i = 0; i < jsonArrayBanner.length(); i++) {
                        JSONObject objJsonBanner = jsonArrayBanner.getJSONObject(i);

                        String banner_id = objJsonBanner.getString("bid");
                        String banner_title = objJsonBanner.getString("banner_title");
                        String banner_desc = objJsonBanner.getString("banner_info");
                        String banner_image = objJsonBanner.getString("banner_image").replace(" ", "%20");
                        if (banner_image.equals("")) {
                            banner_image = "null";
                        }

                        arrayListBanner.add(new ItemHomeSlider(banner_id,banner_title,banner_desc,banner_image));
                    }
                    itemPost.setArrayListBanner(arrayListBanner);
                    arrayListPost.add(itemPost);
                }

                if (jsonObject.has("recently_radio")) {

                    JSONArray jsonArrayRecent = jsonObject.getJSONArray("recently_radio");

                    if (jsonArrayRecent.length() > 0) {

                        postTitle = "Recently Played";
                        postType = "recent";
                        itemPost = new ItemPost("", postTitle, postType, false);

                        ArrayList<ItemRadio> arrayListRecent = new ArrayList<>();
                        for (int i = 0; i < jsonArrayRecent.length(); i++) {
                            JSONObject objJson = jsonArrayRecent.getJSONObject(i);

                            String id = objJson.getString("id");
                            String catId = objJson.getString("cat_id");
                            String radioTitle = objJson.getString("radio_title");
                            String radioURL = objJson.getString("radio_url");
                            String image = objJson.getString("image").replace(" ", "%20");
                            if (image.equals("")) {
                                image = "null";
                            }
                            String averageRating = objJson.getString("averageRating");
                            String totalRate = objJson.getString("totalRate");
                            String catName = objJson.getString("category_name");
                            String total_views = objJson.getString("total_views");
                            boolean isFav = objJson.getBoolean("is_favourite");

                            ItemRadio objItem = new ItemRadio(id, catId, radioTitle, radioURL, image,averageRating,totalRate,total_views,catName,isFav);
                            arrayListRecent.add(objItem);
                        }
                        itemPost.setArrayListRadio(arrayListRecent);
                        arrayListPost.add(itemPost);
                    }
                }

                if (jsonObject.has("latest_radio")) {

                    JSONArray jsonArrayLatest = jsonObject.getJSONArray("latest_radio");

                    if (jsonArrayLatest.length() > 0) {

                        postTitle = "latest radio";
                        postType = "latest";
                        itemPost = new ItemPost("", postTitle, postType, false);

                        ArrayList<ItemRadio> arrayListLatest = new ArrayList<>();
                        for (int i = 0; i < jsonArrayLatest.length(); i++) {
                            JSONObject objJson = jsonArrayLatest.getJSONObject(i);

                            String id = objJson.getString("id");
                            String catId = objJson.getString("cat_id");
                            String radioTitle = objJson.getString("radio_title");
                            String radioURL = objJson.getString("radio_url");
                            String image = objJson.getString("image").replace(" ", "%20");
                            if (image.equals("")) {
                                image = "null";
                            }
                            String averageRating = objJson.getString("averageRating");
                            String totalRate = objJson.getString("totalRate");
                            String catName = objJson.getString("category_name");
                            String total_views = objJson.getString("total_views");
                            boolean isFav = objJson.getBoolean("is_favourite");

                            ItemRadio objItem = new ItemRadio(id, catId, radioTitle, radioURL, image,averageRating,totalRate,total_views,catName,isFav);
                            arrayListLatest.add(objItem);
                        }
                        itemPost.setArrayListRadio(arrayListLatest);
                        arrayListPost.add(itemPost);
                    }
                }

                if (jsonObject.has("trending_radio")) {

                    JSONArray jsonArrayTrending = jsonObject.getJSONArray("trending_radio");

                    if (jsonArrayTrending.length() > 0) {

                        postTitle = "Trending Radio";
                        postType = "trending";
                        itemPost = new ItemPost("", postTitle, postType, false);

                        ArrayList<ItemRadio> arrayListTrending = new ArrayList<>();
                        for (int i = 0; i < jsonArrayTrending.length(); i++) {
                            JSONObject objJson = jsonArrayTrending.getJSONObject(i);

                            String id = objJson.getString("id");
                            String catId = objJson.getString("cat_id");
                            String radioTitle = objJson.getString("radio_title");
                            String radioURL = objJson.getString("radio_url");
                            String image = objJson.getString("image").replace(" ", "%20");
                            if (image.equals("")) {
                                image = "null";
                            }
                            String averageRating = objJson.getString("averageRating");
                            String totalRate = objJson.getString("totalRate");
                            String catName = objJson.getString("category_name");
                            String total_views = objJson.getString("total_views");
                            boolean isFav = objJson.getBoolean("is_favourite");

                            ItemRadio objItem = new ItemRadio(id, catId, radioTitle, radioURL, image,averageRating,totalRate,total_views,catName,isFav);
                            arrayListTrending.add(objItem);
                        }
                        itemPost.setArrayListRadio(arrayListTrending);
                        arrayListPost.add(itemPost);
                    }
                }

                if (jsonObject.has("home_sections")) {

                    JSONArray jsonArraySection = jsonObject.getJSONArray("home_sections");

                    for (int j = 0; j < jsonArraySection.length(); j++) {

                        JSONObject jObjHome = jsonArraySection.getJSONObject(j);

                        postId = jObjHome.getString("home_id");
                        postTitle = jObjHome.getString("home_title");
                        postType = jObjHome.getString("home_type");
                        itemPost = new ItemPost(postId, postTitle, postType , true);

                        JSONArray jsonArrayHomeContent = jObjHome.getJSONArray("home_content");

                            switch (postType) {
                                case "category":
                                    ArrayList<ItemCat> arrayListCat = new ArrayList<>();
                                    for (int i = 0; i < jsonArrayHomeContent.length(); i++) {
                                        JSONObject objJson = jsonArrayHomeContent.getJSONObject(i);

                                        String id = objJson.getString("post_id");
                                        String name = objJson.getString("post_title");
                                        String image = objJson.getString("post_image").replace(" ", "%20");
                                        if (image.equals("")) {
                                            image = "null";
                                        }
                                        ItemCat itemCat = new ItemCat(id, name, image);
                                        arrayListCat.add(itemCat);
                                    }
                                    itemPost.setArrayListCategories(arrayListCat);
                                    break;

                                case "countries":
                                    ArrayList<ItemCountries> arrayListPlaylist = new ArrayList<>();
                                    for (int i = 0; i < jsonArrayHomeContent.length(); i++) {
                                        JSONObject objJson = jsonArrayHomeContent.getJSONObject(i);

                                        String id = objJson.getString("post_id");
                                        String name = objJson.getString("post_title");
                                        String image = objJson.getString("post_image").replace(" ", "%20");
                                        if (image.equals("")) {
                                            image = "null";
                                        }

                                        ItemCountries itemCountries = new ItemCountries(id, name, image);
                                        arrayListPlaylist.add(itemCountries);
                                    }
                                    itemPost.setArrayListCountries(arrayListPlaylist);
                                    break;

                                case "podcasts":
                                    ArrayList<ItemPodcasts> arrayListArtist = new ArrayList<>();
                                    for (int i = 0; i < jsonArrayHomeContent.length(); i++) {
                                        JSONObject objJson = jsonArrayHomeContent.getJSONObject(i);

                                        String id = objJson.getString("post_id");
                                        String name = objJson.getString("post_title");
                                        String image = objJson.getString("post_image").replace(" ", "%20");
                                        if (image.equals("")) {
                                            image = "null";
                                        }

                                        ItemPodcasts objItem = new ItemPodcasts(id, name, image);
                                        arrayListArtist.add(objItem);
                                    }
                                    itemPost.setArrayListPodcasts(arrayListArtist);
                                    break;

                                case "radio":
                                    ArrayList<ItemRadio> arrayListRadio = new ArrayList<>();
                                    for (int i = 0; i < jsonArrayHomeContent.length(); i++) {
                                        JSONObject objJson = jsonArrayHomeContent.getJSONObject(i);

                                        String id = objJson.getString("id");
                                        String catId = objJson.getString("cat_id");
                                        String radioTitle = objJson.getString("radio_title");
                                        String radioURL = objJson.getString("radio_url");
                                        String image = objJson.getString("image").replace(" ", "%20");
                                        if (image.equals("")) {
                                            image = "null";
                                        }
                                        String averageRating = objJson.getString("averageRating");
                                        String totalRate = objJson.getString("totalRate");
                                        String catName = objJson.getString("category_name");
                                        String total_views = objJson.getString("total_views");
                                        boolean isFav = objJson.getBoolean("is_favourite");

                                        ItemRadio objItem = new ItemRadio(id, catId, radioTitle, radioURL, image,averageRating,totalRate,total_views,catName,isFav);
                                        arrayListRadio.add(objItem);
                                    }
                                    itemPost.setArrayListRadio(arrayListRadio);
                                    break;
                            }
                            arrayListPost.add(itemPost);
                        }
                    }
            } catch (Exception e) {
                JSONArray jsonArray = mainJson.getJSONArray(Callback.TAG_ROOT);
                JSONObject jsonObject = jsonArray.getJSONObject(0);
                successAPI = jsonObject.getString(Callback.TAG_SUCCESS);
                message = jsonObject.getString(Callback.TAG_MSG);

                e.printStackTrace();
            }
            return "1";
        } catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    @Override
    protected void onPostExecute(String s) {
        homeListener.onEnd(s, message, arrayListPost);
        super.onPostExecute(s);
    }

}